/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275rr;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.MessageDestination;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8275rr.BoxInfo;
import ibm.nways.jdm8275rr.eui.ConfigurationAlternateGroup;
import ibm.nways.jdm8275rr.eui.ConfigurationFolderGroup;
import ibm.nways.jdm8275rr.eui.FaultFolderGroup;
import ibm.nways.ras.RAS;
import ibm.nways.rmon.RmonContext;
import ibm.nways.telnet.TelnetContext;
import ibm.nways.telnet.TelnetPanel;
import ibm.nways.web.WebBrowserGroup;
import ibm.nways.web.WebContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import java.awt.Point;
import java.util.ResourceBundle;

public class Jdm8275rr
extends JdmBrowser {
    private NavigationFolder rootFolder;
    private NavigationBrowser tree;
    private NavigationContext navContext;
    private GenModel deviceModel;
    private BoxInfo boxInfo;
    private static final int RASID = 19;
    private static final int RASSUB = 9;
    private static String bundleName = "ibm.nways.jdm8275rr.Resources";
    private static ResourceBundle myResources = ResourceBundle.getBundle(bundleName);
    private static ResourceBundle commonResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.CommonFolderGroupResources");
    private NavFieldOverride jdm8275rrOverrides;
    static final Object[][] jdm8275rrFieldOverrides = new Object[][]{{"ibm.nways.ethernet.eui.Dot3StatsPanel.Dot3StatBusy.visible", "false"}, {"ibm.nways.ethernet.eui.Dot3StatsPanel.Dot3StatMAC.visible", "false"}, {"ibm.nways.ethernet.eui.Dot3StatsPanel.Dot3StatChip.visible", "false"}, {"ibm.nways.ethernet.model.Dot3Stats.Panel.Dot3StatsSQETestErrors.access", "not-supported"}, {"ibm.nways.ethernet.model.Dot3Stats.Panel.Dot3StatsCarrierSenseErrors.access", "not-supported"}, {"ibm.nways.ethernet.model.Dot3Stats.Panel.Dot3StatsLateCollisions.access", "not-supported"}, {"ibm.nways.bridge.model.Ports.Panel.Dot1dStpPortEnable.access", "read-only"}, {"ibm.nways.mib2.eui.Mib2InterfacesPanel.rfc1573.visible", "false"}, {"ibm.nways.bridge.eui.BridgePortsPanel.sourcerouteports.visible", "false"}, {"ibm.nways.mib2.model.Interface.Panel.IfAdminStatus.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteDest.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric1.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric2.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric3.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric4.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMetric5.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteNextHop.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteType.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteProto.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteAge.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteMask.access", "read-only"}, {"ibm.nways.mib2.model.RouteTable.Panel.IpRouteInfo.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaType.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaIfIndex.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaNetAddress.access", "read-only"}, {"ibm.nways.mib2.model.IpNetToMedia.Panel.IpNetToMediaPhysAddress.access", "read-only"}};
    static final Object[][] model_416Overrides = new Object[0][];

    public String getModelTypeName() {
        return "ibm.nways.jdm8275rr.model.Jdm8275rr";
    }

    public Dimension getDefaultSize() {
        Dimension dimension = new Dimension(800, 600);
        return dimension;
    }

    protected NavigationPoint getNavTreeRoot() {
        String string = "getNavTreeRoot";
        if (RAS.isEnabled(19, 9)) {
            RAS.enter(19, 9, (Object)this, string);
        }
        if (this.deviceModel != null || this.boxInfo != null) {
            if (RAS.isEnabled(19, 9)) {
                RAS.trace(19, 9, (Object)this, string, "redraw request but still need to call dispose");
            }
            this.dispose();
        }
        this.deviceModel = (GenModel)this.getModel();
        if (this.deviceModel == null) {
            this.rootFolder = new NavigationFolder(this.getNLSString("unknown"));
            this.navContext = this.rootFolder.getNavContext();
            if (RAS.isEnabled(19, 9)) {
                RAS.trace(19, 9, (Object)this, string, "deviceModel is NULL!");
                RAS.exit(19, 9, (Object)this, string);
            }
            return this.rootFolder;
        }
        this.boxInfo = new BoxInfo(this.deviceModel, this);
        this.rootFolder = this.boxInfo.getDeviceStatus() == 1 ? new NavigationFolder(this.getNLSString("deviceName")) : new NavigationFolder(this.getNLSString("unknown"));
        this.navContext = this.rootFolder.getNavContext();
        BoxInfo.setInNavContext(this.navContext, this.boxInfo);
        this.jdm8275rrOverrides = new NavFieldOverride(this.navContext, jdm8275rrFieldOverrides);
        switch (this.boxInfo.getDeviceType()) {
            case 1: {
                this.addOverrides(this.jdm8275rrOverrides, model_416Overrides);
                break;
            }
        }
        if (RAS.isEnabled(19, 9)) {
            RAS.exit(19, 9, (Object)this, string);
        }
        return this.rootFolder;
    }

    public GraphicPanel getDeviceGraphicPanel() {
        GraphicPanel graphicPanel = null;
        String string = "getDeviceGraphicPanel";
        if (RAS.isEnabled(19, 9)) {
            RAS.enter(19, 9, (Object)this, string);
        }
        long l = System.currentTimeMillis();
        if (this.deviceModel != null) {
            this.displayMsg(this.getNLSString("StartGraphic"));
            graphicPanel = this.boxInfo.getDeviceGraphic();
            this.displayMsg(this.getNLSString("EndGraphic"));
        } else {
            if (RAS.isEnabled(19, 9)) {
                RAS.trace(19, 9, (Object)this, string, "Can't draw graphic");
            }
            GraphicContainer graphicContainer = new GraphicContainer();
            Label label = new Label(this.getNLSString("NoGraphic"), 1);
            label.setFont(new Font("Arial", 1, 14));
            label.setLocation(new Point(35, -5));
            graphicContainer.add(label);
            graphicPanel = new GraphicPanel((GraphicHandler)this, (Component)graphicContainer);
        }
        long l2 = System.currentTimeMillis();
        if (RAS.isEnabled(19, 9)) {
            RAS.trace(19, 9, (Object)this, string, "Finished device picture in " + String.valueOf(l2 - l) + " msecs");
            RAS.exit(19, 9, (Object)this, string);
        }
        return graphicPanel;
    }

    protected void getRestOfNavTree() {
        String string = "getRestOfNavTree";
        if (RAS.isEnabled(19, 9)) {
            RAS.enter(19, 9, (Object)this, string);
        }
        this.displayMsg(this.getNLSString("StartNavTree"));
        long l = System.currentTimeMillis();
        this.tree = this.getNavigationBrowser();
        this.navContext.put((Object)"TREE", (Object)this.tree);
        int[] nArray = new int[9];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        RmonContext rmonContext = new RmonContext(nArray2, nArray3, nArray4);
        this.navContext.put((Object)"rmonContext", (Object)rmonContext);
        if (this.deviceModel != null && (this.boxInfo.getDeviceStatus() == 1 || this.boxInfo.getDeviceStatus() == 3)) {
            this.buildConfigurationFolder(this.rootFolder);
            this.buildFaultFolder(this.rootFolder);
            this.buildToolsFolder(this.rootFolder);
            if (RAS.isEnabled(19, 9)) {
                RAS.trace(19, 9, (Object)this, string, "Built full nav tree.");
            }
        } else {
            this.buildAltConfigurationFolder(this.rootFolder);
            this.buildToolsFolder(this.rootFolder);
            if (RAS.isEnabled(19, 9)) {
                RAS.trace(19, 9, (Object)this, string, "Built partial nav tree.");
            }
        }
        this.displayMsg(this.getNLSString("EndNavTree"));
        long l2 = System.currentTimeMillis();
        if (RAS.isEnabled(19, 9)) {
            RAS.trace(19, 9, (Object)this, string, "Completed Navigation Tree in " + String.valueOf(l2 - l) + " msecs");
            RAS.exit(19, 9, (Object)this, string);
        }
    }

    public void dispose() {
        String string = "dispose";
        if (RAS.isEnabled(19, 9)) {
            RAS.enter(19, 9, (Object)this, string);
        }
        if (this.boxInfo != null) {
            this.boxInfo.dispose();
            this.boxInfo = null;
        }
        this.rootFolder = null;
        this.tree = null;
        this.navContext = null;
        this.jdm8275rrOverrides = null;
        this.deviceModel = null;
        if (RAS.isEnabled(19, 9)) {
            RAS.exit(19, 9, (Object)this, string);
        }
    }

    public String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            try {
                string2 = commonResources.getString(string);
            }
            catch (Exception exception2) {
                string2 = string;
                RAS.logWarning(19, 9, (Object)this, "getNLSString", "EXCEPTION_ACCESSING_RESOURCE", (Object)string, (Object)bundleName);
                RAS.logException(19, 9, (Object)this, "getNLSString", exception);
            }
        }
        return string2;
    }

    private void buildConfigurationFolder(NavigationFolder navigationFolder) {
        String string = "buildConfigurationFolder";
        if (RAS.isEnabled(19, 9)) {
            RAS.enter(19, 9, (Object)this, string);
        }
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.deviceModel.getComponent("ConfigurationFolder");
            ConfigurationFolderGroup configurationFolderGroup = new ConfigurationFolderGroup((JdmBrowser)this, genModel);
            this.tree.addEventListener((NavigationBrowserEventListener)configurationFolderGroup);
            configurationFolderGroup.setIsInitiallyExpanded(false);
            navigationFolder.add((NavigationPoint)configurationFolderGroup);
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 9)) {
                RAS.trace(19, 9, (Object)this, string, "Missing full Configuration Folder -Exception getting config Model");
            }
            RAS.logException(19, 9, (Object)this, string, exception);
            this.buildAltConfigurationFolder(navigationFolder);
        }
        if (RAS.isEnabled(19, 9)) {
            RAS.exit(19, 9, (Object)this, string);
        }
    }

    private void buildAltConfigurationFolder(NavigationFolder navigationFolder) {
        String string = "buildAltConfigurationFolder";
        if (RAS.isEnabled(19, 9)) {
            RAS.enter(19, 9, (Object)this, string);
        }
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.deviceModel.getComponent("ConfigALT");
        }
        catch (Exception exception) {
            RAS.logException(19, 9, (Object)this, string, exception);
            genModel = this.deviceModel;
        }
        if (genModel == null) {
            genModel = this.deviceModel;
        }
        ConfigurationAlternateGroup configurationAlternateGroup = new ConfigurationAlternateGroup((JdmBrowser)this, genModel);
        this.tree.addEventListener((NavigationBrowserEventListener)configurationAlternateGroup);
        configurationAlternateGroup.setIsInitiallyExpanded(false);
        navigationFolder.add((NavigationPoint)configurationAlternateGroup);
        if (RAS.isEnabled(19, 9)) {
            RAS.exit(19, 9, (Object)this, string);
        }
    }

    private void buildFaultFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        String string = "buildFaultFolder";
        if (RAS.isEnabled(19, 9)) {
            RAS.enter(19, 9, (Object)this, string);
        }
        try {
            genModel = (GenModel)this.deviceModel.getComponent("Fault");
        }
        catch (Exception exception) {
            RAS.logException(19, 9, (Object)this, string, exception);
        }
        if (genModel != null) {
            FaultFolderGroup faultFolderGroup = new FaultFolderGroup((JdmBrowser)this, genModel);
            faultFolderGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)faultFolderGroup);
            navigationFolder.add((NavigationPoint)faultFolderGroup);
        } else {
            navigationFolder.add((NavigationPoint)new NavigationItem(this.getNLSString("FaultGroupTitle"), (NavigationDestination)new MessageDestination(this.getNLSString("NotConfigured"))));
        }
        if (RAS.isEnabled(19, 9)) {
            RAS.exit(19, 9, (Object)this, string);
        }
    }

    private void buildToolsFolder(NavigationFolder navigationFolder) {
        NavigationFolder navigationFolder2 = new NavigationFolder(this.getNLSString("ToolsGroupTitle"));
        NavigationContext navigationContext = null;
        SnmpContextModel snmpContextModel = null;
        String string = null;
        String string2 = "buildToolsFolder";
        if (RAS.isEnabled(19, 9)) {
            RAS.enter(19, 9, (Object)this, string2);
        }
        navigationFolder2.setDestination(new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        navigationFolder2.setIsInitiallyExpanded(true);
        navigationFolder.add((NavigationPoint)navigationFolder2);
        try {
            WebBrowserGroup webBrowserGroup;
            WebContext webContext;
            snmpContextModel = (SnmpContextModel)this.deviceModel.getComponent("_ContextInfo");
            ModelInfo modelInfo = snmpContextModel.getConfig();
            string = modelInfo.get("Config.Address").toString();
            TelnetContext telnetContext = new TelnetContext(string);
            NavigationItem navigationItem = new NavigationItem(TelnetPanel.getTitle(), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
            navigationContext = navigationItem.getNavContext();
            navigationContext.put((Object)"telnetContext", (Object)telnetContext);
            navigationFolder2.add((NavigationPoint)navigationItem);
            NavigationBrowser navigationBrowser = this.getNavigationBrowser();
            Browser browser = new Browser(this.getNLSString("MibBrowser"), (JdmBrowser)this, snmpContextModel);
            navigationBrowser.addEventListener((NavigationBrowserEventListener)browser);
            navigationFolder2.add((NavigationPoint)browser.getRootFolder());
            if (this.getIsApplication()) {
                webContext = new AnalyzerJdmContext(string, this.getServerPortNumber());
                webBrowserGroup = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = webBrowserGroup.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", (Object)webContext);
                navigationFolder2.add((NavigationPoint)webBrowserGroup);
            }
            webContext = new WebContext(string);
            webContext.support_and_device();
            webBrowserGroup = new WebBrowserGroup(webContext);
            webBrowserGroup.setDestination(new NavigationDestination("ibm.nways.jdm.NilDestination", null));
            webBrowserGroup.setIsInitiallyExpanded(false);
            navigationBrowser.addEventListener((NavigationBrowserEventListener)webBrowserGroup);
            navigationFolder2.add((NavigationPoint)webBrowserGroup);
            return;
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 9)) {
                RAS.trace(19, 9, (Object)this, string2, "Can't build dependent folders");
            }
            RAS.logException(19, 9, (Object)this, string2, exception);
            if (RAS.isEnabled(19, 9)) {
                RAS.exit(19, 9, (Object)this, string2);
            }
            return;
        }
    }

    private void addOverrides(NavFieldOverride navFieldOverride, Object[][] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            navFieldOverride.put(objectArray[n][0], objectArray[n][1]);
            ++n;
        }
    }
}

